<div class="card">
  <h1 class="h1">Compra e venda na sua cidade</h1>
  <p class="muted">Base simples. Depois você muda regras de entrega, pedidos, categorias, etc.</p>

  <form method="get" action="/public/index.php" class="row" style="align-items:end">
    <input type="hidden" name="page" value="home">
    <div style="flex:1">
      <label>Buscar</label>
      <input class="input" name="q" value="<?= e($q ?? '') ?>" placeholder="Ex: fone, camisa, mercado...">
    </div>
    <div>
      <button class="btn" type="submit">Pesquisar</button>
    </div>
  </form>
</div>

<div class="hr"></div>

<div class="grid">
<?php foreach ($products as $p): ?>
  <div class="card">
    <div style="display:flex;justify-content:space-between;gap:10px">
      <div>
        <div style="font-weight:900"><?= e($p['title']) ?></div>
        <div class="muted" style="font-size:13px">Vendedor: <?= e($p['seller_name']) ?></div>
        <?php if (!empty($p['city'])): ?><div class="muted" style="font-size:13px">Cidade: <?= e($p['city']) ?></div><?php endif; ?>
      </div>
      <div style="text-align:right">
        <div style="font-weight:900"><?= e(money_br((int)$p['price_cents'])) ?></div>
        <div class="muted" style="font-size:13px">Estoque: <?= (int)$p['stock'] ?></div>
      </div>
    </div>

    <div class="hr"></div>

    <div class="row">
      <a class="btn btn-ghost" href="/public/index.php?page=product&id=<?= (int)$p['id'] ?>">Ver</a>
      <button class="btn" type="button"
        data-add-to-cart
        data-id="<?= (int)$p['id'] ?>"
        data-title="<?= e($p['title']) ?>"
        data-price-cents="<?= (int)$p['price_cents'] ?>"
      >Adicionar</button>
    </div>
  </div>
<?php endforeach; ?>
</div>
