<div class="card">
  <h1 class="h1">Carrinho</h1>

  <?php if (!empty($error)): ?>
    <div class="alert"><?= e($error) ?></div>
    <div class="hr"></div>
  <?php endif; ?>

  <div data-cart-root></div>

  <div class="hr"></div>

  <?php if (!$user): ?>
    <div class="alert">
      Para finalizar pedido, você precisa entrar.
      <div class="hr"></div>
      <a class="btn" href="/public/index.php?page=login">Entrar</a>
    </div>
  <?php else: ?>
    <form method="post" action="/public/index.php?page=checkout">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <input type="hidden" name="cart_json" value="[]">

      <label>Forma de entrega</label>
      <select name="delivery_type" class="input">
        <option value="delivery">Entrega</option>
        <option value="pickup">Retirar</option>
      </select>

      <label>Endereço (se entrega)</label>
      <input class="input" name="delivery_address" placeholder="Rua, número, bairro">

      <label>Observação</label>
      <input class="input" name="delivery_notes" placeholder="Ex: ponto de referência, horário...">

      <div class="hr"></div>
      <button class="btn" type="submit">Finalizar pedido</button>
    </form>
  <?php endif; ?>
</div>
