-- Cidade Shop MVP
-- MySQL/MariaDB

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(190) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('buyer','seller','admin') NOT NULL DEFAULT 'buyer',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS products (
  id INT AUTO_INCREMENT PRIMARY KEY,
  seller_id INT NOT NULL,
  title VARCHAR(180) NOT NULL,
  description TEXT NULL,
  price_cents INT NOT NULL,
  stock INT NOT NULL DEFAULT 0,
  city VARCHAR(120) NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (seller_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS orders (
  id INT AUTO_INCREMENT PRIMARY KEY,
  buyer_id INT NOT NULL,
  total_cents INT NOT NULL,
  status ENUM('new','paid','preparing','shipped','delivered','canceled') NOT NULL DEFAULT 'new',
  delivery_type ENUM('pickup','delivery') NOT NULL DEFAULT 'delivery',
  delivery_address VARCHAR(255) NULL,
  delivery_notes VARCHAR(255) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (buyer_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS order_items (
  id INT AUTO_INCREMENT PRIMARY KEY,
  order_id INT NOT NULL,
  product_id INT NOT NULL,
  seller_id INT NOT NULL,
  qty INT NOT NULL,
  price_cents INT NOT NULL,
  title_snapshot VARCHAR(180) NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE,
  FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE RESTRICT,
  INDEX (seller_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Seeds: cria um admin e um vendedor exemplo (troque senhas depois)
-- senha: admin123 / seller123 (apenas para teste)
INSERT IGNORE INTO users (id,name,email,password_hash,role) VALUES
(1,'Admin','admin@local',  '$2y$10$TawjzXo8vbgpKBYp7d4gW.yiScNstfzLVGN8XQXfB0aQEjxQJ8mNi', 'admin'),
(2,'Vendedor','seller@local','$2y$10$VXv8r3nH0yF6g4J9S6y6uee3q8QmM1m2Wc8m0QXwG8V.7m4oO.1bO', 'seller');

INSERT IGNORE INTO products (seller_id,title,description,price_cents,stock,city,is_active) VALUES
(2,'Camiseta básica','Tamanhos P/M/G. Entrega rápida.', 4990, 25, 'Parauapebas', 1),
(2,'Fone bluetooth','Bateria 6h. Estojo carregador.', 12990, 10, 'Parauapebas', 1);
