<?php
declare(strict_types=1);

function db_connect(array $db): PDO {
  $dsn = sprintf("mysql:host=%s;dbname=%s;charset=%s", $db['host'], $db['name'], $db['charset'] ?? 'utf8mb4');
  $pdo = new PDO($dsn, $db['user'], $db['pass'], [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
  return $pdo;
}

function db_one(PDO $db, string $sql, array $params = []): ?array {
  $st = $db->prepare($sql);
  $st->execute($params);
  $row = $st->fetch();
  return $row ?: null;
}

function db_all(PDO $db, string $sql, array $params = []): array {
  $st = $db->prepare($sql);
  $st->execute($params);
  return $st->fetchAll();
}

function db_exec(PDO $db, string $sql, array $params = []): int {
  $st = $db->prepare($sql);
  $st->execute($params);
  return (int)$db->lastInsertId();
}
