# Cidade Shop (MVP em PHP) — pronto para subir no UOL Host

Este é um MVP (base) de um marketplace estilo “compra e venda” para a sua cidade.
Foco: funcionalidade simples e fácil de evoluir.

## O que já vem pronto (MVP)
- Cadastro e login de usuários
- Produtos (listagem + detalhe)
- Carrinho (localStorage) + checkout criando pedido no banco
- Área do vendedor (cadastrar produtos)
- Painel “Meus pedidos”
- Integração com seu ERP: **stub** (endpoint para você plugar depois)

> Design propositalmente simples (sem “cara” de Mercado Livre), fácil de alterar.

---

## Requisitos
- PHP 8+ (funciona em PHP 7.4 com pequenas adaptações)
- MySQL/MariaDB
- Extensões: PDO, PDO_MySQL

## Como instalar
1) Crie um banco no seu host (MySQL) e um usuário.
2) Importe o schema:
   - arquivo: `database/schema.sql`
3) Configure o arquivo:
   - copie `config/config.example.php` para `config/config.php`
   - edite as credenciais do MySQL e o `APP_URL`

4) Suba os arquivos para o UOL Host (pasta do site).
5) Acesse:
   - `/public/` (se não tiver subpasta, você pode mover o conteúdo de `public` para a raiz)

## Estrutura
- `public/` → arquivos públicos (index.php, assets)
- `app/` → backend (controllers, auth, db)
- `config/` → config do ambiente
- `database/` → SQL
- `storage/` → uploads (crie e dê permissão no host)

## Segurança (o básico)
- Senhas com password_hash()
- PDO com prepared statements
- CSRF token simples em formulários críticos

## Próximos passos sugeridos
- Categoria e busca avançada
- Chat comprador/vendedor
- Upload de fotos
- Frete/entrega (sua melhoria)
- Aprovação/validação de vendedores
- Integração real com seu ERP (webhook / API)

